<?php require_once('./includes/header.php'); ?>
<main class="innerpages contact_us">
    <div class="banner_wrapper" style="background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url('./assets/images/inner-pages/Contact-Us.jpg?ver=3g');">
        <h1>Contact Us</h1>
    </div>
    <div class="content_wrapper">
        <div class="container">
            <div class="row gx-5">
                <div class="col-lg-6 d_flex">
                   <div class="side_contact_details">
                   <div class="logo_wrapper d-none d-xl-flex">
                        <div class="img_wrap">
                            <img src="./assets/images/main_logo-2.png?v=1" alt="" class="img-fluid">
                        </div>
                    </div>
                    <div class="wrap">
                        <div class="icon_wrap">
                            <img src="./assets/images/p_icon.png" alt="">
                        </div>
                        <span><a href="tel:<?php echo $tel1; ?>"><?php echo $tel1; ?></a></span>
                        <span><a href="tel:<?php echo $tel2; ?>"><?php echo $tel2; ?></a></span>
                    </div>
                    <div class="wrap">
                        <div class="icon_wrap">
                            <img src="./assets/images/e_icon.png" alt="">
                        </div>
                        <span><a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></span>
                    </div>
                    <div class="wrap">
                        <div class="icon_wrap">
                            <img src="./assets/images/g_icon.png" alt="">
                        </div>
                        <span><a href="<?php echo $base_url; ?>"><?php echo $weburl; ?></a></span>
                    </div>
                    <div class="wrap">
                        <div class="icon_wrap">
                            <img src="./assets/images/l_icon.png" alt="">
                        </div>
                        <span><a href="javascript:"><?php echo $address; ?></a></span>
                    </div>

                    <div class="wrap" style="align-items:flex-start;">
                        <div class="icon_wrap">
                            <img src="./assets/images/clock.png" alt="">
                        </div>
                        <span><ul>
                            <li><span>Mon - Sat:</span> 8:00 am – 8:00 pm</li>
                            <!-- <li><span>Tue:</span> 9:00 am – 6:00 pm</li>
                            <li><span>Wed:</span> 9:00 am – 6:00 pm</li>
                            <li><span>Thu:</span> 9:00 am – 6:00 pm</li>
                            <li><span>Fri:</span> 9:00 am – 6:00 pm</li>
                            <li><span>Sat:</span> 9:00 am – 6:00 pm</li> -->
                            <li><span>Sun:</span> Closed</li>
                        </ul></span>
                    </div>
                   
                   </div>
                </div>
                <div class="col-lg-6">
                <div class="form_wrapper">
                <h6>Contact Form</h6>
                <form id="myForm" enctype="multipart/form-data">
                <?php function generateRandomString($length = 10) {
                    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                        $charactersLength = strlen($characters);
                        $randomString = '';
                        for ($i = 0; $i < $length; $i++) {
                            $randomString .= $characters[rand(0, $charactersLength - 1)];
                        }
                        return $randomString;
                    }  ?>
            <input type="hidden" name="custom_token" id="customToken" value="<?php echo generateRandomString(); ?>">
                    <div class="row gx-3">
                        <div class="col-sm-6">
                            <input type="text" class="form-control" placeholder="First Name" id="fname" name="fname" autocomplete="off" required/>
                        </div>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" placeholder="Last Name" id="lname" name="lname" autocomplete="off" required/>
                        </div>
                        <div class="col-sm-6">
                            <input type="tel" class="form-control" placeholder="Phone Number" id="phone" name="phone" autocomplete="off" required/>
                        </div>
                        <div class="col-sm-6">
                            <input type="email" class="form-control" placeholder="Email" id="email"  name="email" autocomplete="off" required/>
                        </div>
                     
                        <div class="col-12">
                            <textarea id="message" name="message" class="form-control" placeholder="Message Description" autocomplete="off" required></textarea>
                        </div>
                     
                            <button type="submit" class="__btn_submit" id="btn-submit">Submit</button>
                            <ul id="error-messages"></ul>
                            <div id="successMsg" class="success_msg"></div>
                      
                    </div>
                </form>
            </div>
                </div>
                <div class="col-12">
                <div class="map_wrapper">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2496.57053348768!2d-1.0917148999999997!3d51.263816299999995!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x48742185dc59ed3d%3A0x1efcaf04e9ffab48!2s78%20Flaxfield%20Rd%2C%20Basingstoke%20RG21%208SF%2C%20UK!5e0!3m2!1sen!2s!4v1762517086723!5m2!1sen!2s" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>

            </div>
        </div>
    </div>
</main>

<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body">
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      <strong>Thanks for being awesome!</strong><br/><br/>
We have received your message and would like to thank you for writing to us. If your inquiry is urgent, please use the telephone number to talk to one of our staff members. Otherwise, we will reply by email as soon as possible. Thanks, and warm regards.<br/><br/>

<strong><?php echo $site_name; ?></strong>
      </div>
    </div>
  </div>
</div>


<script>
$(document).ready(function(e){
    // Submit form data via Ajax
    $("#myForm").on('submit', function(e){
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: '<?php echo $base_url;?>/form-process.php',
            data: new FormData(this),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function(){
                $('#btn-submit').attr("disabled","disabled");
                $('#myForm').css("opacity",".5");
            },
            success: function(response){
                $('#successMsg').html('');
                if(response.status == 1){
                    $('#myForm')[0].reset();
                    $("#staticBackdrop").modal('show');
                }else{
                    $('#successMsg').html('<span class="alert alert-danger">'+response.message+'</span>');
                }
                $('#myForm').css("opacity","");
                $("#btn-submit").removeAttr("disabled");
            }
        });
    });
});
</script>



<?php require_once('./includes/footer.php'); ?>